<?php

$i = 1;
$gallery_images = get_post_meta( $post->ID, 'vdw_gallery_id', true );

get_header();

if ( have_posts() ) : while ( have_posts() ) : the_post();

	?>
	<div class="page-image-para">
		<div class="parallax-window" data-parallax="scroll" data-image-src="<?php echo get_the_post_thumbnail_url() ?>"></div>
		<div class="pattern"></div>
	</div>
	<header class="page-header">
		<div class="container">
			<h1 class="title">
				<?php echo get_the_title(); ?>
			</h1>
			<?php nika_breadcrumbs(); ?>
		</div>
	</header>
	<div class="page-content">
		<div class="container">
			<div class="lines">
				<div class="line-1"></div>
				<div class="line-2"></div>
			</div>
			<div class="page-body">
				<div class="row">
					<div id="content" class="content-full">
						<div class="content-wrapper">
							<article id="post-<?php echo intval( get_the_ID() ); ?>" <?php post_class(); ?>>
								<?php the_content(); ?>
							</article>
						</div>
						<?php if ( !empty( $gallery_images ) ) : ?>
							<ul class="gallery-list single-gallery-list row">
								<?php foreach ( $gallery_images as $image ) : ?>
									<li class="col-sm-6 col-md-6 col-lg-4">
										<div class="img" onclick="openModal();currentSlide(<?php echo intval( $i++ ); ?>);">
											<img src="<?php echo esc_url( wp_get_attachment_image_url( $image, 'thumb-xs' ) ); ?>">
											<div class="hover"></div>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div id="myModal" class="modal">
		<span class="close cursor" onclick="closeModal()">&times;</span>
		<div class="modal-body">
			<?php
			if ( !empty( $gallery_images ) ) :
				foreach ( $gallery_images as $image ) :
					?>
					<div class="item">
						<div class="img">
							<img src="<?php echo esc_url( wp_get_attachment_image_url( $image, 'thumb-lg' ) ); ?>">
						</div>
					</div>
				<?php
				endforeach;
			endif;
			?>
			<a class="prev" onclick="plusSlides(-1)">&#10094;</a>
			<a class="next" onclick="plusSlides(1)">&#10095;</a>
		</div>
	</div>
	<script>
        function openModal() {
            document.getElementById('myModal').style.display = "block";
        }

        function closeModal() {
            document.getElementById('myModal').style.display = "none";
        }

        var slideIndex = 1;
        showSlides(slideIndex);

        function plusSlides(n) {
            showSlides(slideIndex += n);
        }

        function currentSlide(n) {
            showSlides(slideIndex = n);
        }

        function showSlides(n) {
            var i;
            var slides = document.getElementsByClassName("item");
            var dots = document.getElementsByClassName("demo");
            var captionText = document.getElementById("caption");

            if (n > slides.length) {
                slideIndex = 1
            }
            if (n < 1) {
                slideIndex = slides.length
            }
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            for (i = 0; i < dots.length; i++) {
                dots[i].className = dots[i].className.replace(" active", "");
            }
            slides[slideIndex - 1].style.display = "block";
            dots[slideIndex - 1].className += " active";
            captionText.innerHTML = dots[slideIndex - 1].alt;
        }
	</script>
<?php

endwhile; endif;

get_footer();

?>
