<?php

$args = array(
	
	'orderby'    => 'name',
	'order'      => 'ASC',
	'taxonomy'   => 'category',
	
	// 'hide_empty' => 0,
	
);

$categories = get_categories( $args );

foreach ( $categories as $category ) { 

	$cats[] = $category->slug ;  
	
}

$meta_box = array(
    'id'       => 'custom-meta-box',
    'title'    => __( 'تنظیمات پست ها برای این صفحه', '' ),
    'page'     => 'page',
    'context'  => 'normal',
    'priority' => 'high',
    'fields'   => array(
		array(
            'name'    => __( 'نمایش نوشته ها به صورت تب بازشو', '' ),
            'desc'    => __( 'در صورت نمایش ، یک دسته بندی انتخاب کنید', '' ),
            'id'      => 'erteashat_metabox_tabs',
            'type'    => 'select',
            'options' => $cats
        ),
		array(
            'name'    => __( 'نمایش نوشته ها به صورت اسلایدشو', '' ),
			'desc'    => __( 'در صورت نمایش ، یک دسته بندی انتخاب کنید', '' ),
            'id'      => 'erteashat_metabox_slider',
            'type'    => 'select',
            'options' => $cats
        ),
		array(
            'name'    => __( 'توضیح نوشته برای قسمت اسلایدشو', '' ),
			'desc'    => __( 'در صورت نمایش ، عنوان مطلب را پر کنید', '' ),
            'id'      => 'erteashat_metabox_slider_title',
            'type'    => 'text',
        ),
	)
);

add_action( 'admin_menu', 'add_my_box' );

function add_my_box() {
	
    global $meta_box;
	
	add_meta_box( $meta_box['id'], $meta_box['title'], 'metabox_callback', $meta_box['page'], $meta_box['context'], $meta_box['priority'] );

}

function metabox_callback(){
	
	global $meta_box, $post;

    echo '<input type="hidden" name="META_BOX_NONEC" value="', wp_create_nonce( basename( __FILE__ ) ), '" />';

    foreach ( $meta_box['fields'] as $field ) {

        $meta = get_post_meta( $post->ID, $field['id'], true );
		
		echo 
			'<div class="apanel">',
				'<div class="apanel-body clearfix">';

		echo 
			'<div class="apanel-name">',
				'<span class="inner">',
					$field['name'],
				'</span>',
			'</div>';
	
		echo 
			'<div class="apanel-content">';
		
        switch ( $field['type'] ) {
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : '', '" />';
				break;
            case 'select':
                echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				echo '<option value="none">' . __( 'عدم نمایش', '' ) . '</option>';
                foreach ($field['options'] as $option) {
                    echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
                }
                echo '</select>';
                break;
        }
		
		echo '<br><span class="description">', $field['desc'] ,'</span>';
		
		echo 
				'</div>',
			'</div>',
		'</div>';
		
    }
}

function save_my_meta_box( $post_id ) {
	
    global $meta_box;

    if ( ! wp_verify_nonce( $_POST['META_BOX_NONEC'], basename(__FILE__) ) ) {
        return $post_id;
	}
	
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return $post_id;
    }

    if ( 'page' == $_POST['post_type'] ) {
        if ( ! current_user_can( 'edit_page', $post_id ) ) {
            return $post_id;
        }
    } elseif ( ! current_user_can( 'edit_post', $post_id )) {
        return $post_id;
    }

    foreach ( $meta_box['fields'] as $field ) {
        $old = get_post_meta( $post_id, $field['id'], true );
        $new = $_POST[$field['id']];

        if ( $new && $new != $old ) {
            update_post_meta( $post_id, $field['id'], $new );
        } elseif ( '' == $new && $old ) {
            delete_post_meta( $post_id, $field['id'], $old );
        }
    }
}

add_action( 'save_post', 'save_my_meta_box' );

?>