<?php

/*
 * Enqueues scripts and styles
 */

function theme_enqueue_scripts() {

	wp_enqueue_script( 'jquery' );
	
	wp_enqueue_style( 'font-awesome', THEME_PATH . '/assets/css/font-awesome.min.css', array(), '4.7.0' );

	wp_enqueue_style( 'owl-carousel', THEME_PATH . '/assets/css/owl.carousel.min.css', array(), '2.2.1' );

	wp_enqueue_style( 'bootstrap', THEME_PATH . '/assets/css/bootstrap.min.css', array(), '3.3.7' );
	
	wp_enqueue_style( 'erteashat-style', get_stylesheet_uri() , array(), THEME_VERSION );

	if ( is_rtl() ) {
		wp_enqueue_style( 'erteashat-rtl', THEME_PATH . '/rtl.css', array(), THEME_VERSION );
	} else {
		wp_enqueue_style( 'erteashat-ltr', THEME_PATH . '/assets/css/ltr.css', array(), THEME_VERSION );
	}


	wp_enqueue_script( 'bootstrap', THEME_PATH . '/assets/js/bootstrap.min.js', array( 'jquery' ), '3.3.7', true );

	wp_enqueue_script( 'owl-carousel', THEME_PATH . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '2.2.1', true );
	
	wp_enqueue_script( 'parallax', THEME_PATH . '/assets/js/parallax.min.js', array( 'jquery' ), '1.4.2', true );
	
	wp_enqueue_script( 'erteashat-js', THEME_PATH . '/assets/js/main.js', array( 'jquery' ), THEME_VERSION, true );
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_scripts' );

/*
 * Admin Enqueue Scripts
 */

function nika_admin_enqueue_scripts( $hook ) {
	
	wp_enqueue_media();
	
	wp_register_style( 'theme-admin-style', THEME_PATH . '/includes/admin/assets/css/theme-admin-style.css', array(), THEME_VERSION );
	wp_enqueue_style( 'theme-admin-style' );
	
	wp_register_script( 'theme-admin-scripts', THEME_PATH . '/includes/admin/assets/js/theme-admin-scripts.js', array( 'jquery' ), THEME_VERSION,  true ); 
	wp_enqueue_script( 'theme-admin-scripts' );
		
}
add_action( 'admin_enqueue_scripts', 'nika_admin_enqueue_scripts' );
	
?>