<?php

/*------------------/
 * Content Width
**------------------*/

if ( !isset( $content_width ) ) {
	$content_width = 660;
}

/*------------------/
 * Theme Setup
**------------------*/

if ( !function_exists( 'nika_setup' ) ) :

	function nika_setup ()
	{

		/*
		 * translation.
		 */

		load_theme_textdomain( 'nika' );

		/*
		 * Add default posts and comments RSS feed links to head.
		 */

		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 */

		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 */

		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 825, 510, true );
		add_image_size( 'thumb-ve', 342, 480, true );
		add_image_size( 'thumb-xs', 450, 300, true );
		add_image_size( 'thumb-ch', 450, 450, true );
		add_image_size( 'thumb-sm', 600, 400, true );
		add_image_size( 'thumb-md', 750, 450, true );
		add_image_size( 'thumb-lg', 1024, 680, true );
		add_image_size( 'thumb-xl', 1440, 810, true );
		add_image_size( 'thumb-xx', 750, 1500, true );

		/*
		 * This theme uses wp_nav_menu() in two locations.
		 */

		register_nav_menus( array(
			'main' => __( 'Primary Menu', 'nika' ),
			'footer' => __( 'Footer Menu', 'nika' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption'
		) );

		/*
		 * Enable support for Post Formats.
		 */

		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'quote',
			'link',
			'gallery',
			'status',
			'audio',
			'chat'
		) );

		/*
		 * Enable support for custom logo.
		 */

		add_theme_support( 'custom-logo', array(
			'height' => 248,
			'width' => 248,
			'flex-height' => true,
		) );

	}
endif;
add_action( 'after_setup_theme', 'nika_setup' );

/*------------------/
 * Register sidebars
**------------------*/

function nika_widgets_init ()
{

	$widget_names = array( 'category', 'default', 'single', 'blog', 'page' );

	foreach ( $widget_names as $widget_name ) {

		register_sidebar( array(
			'name' => __( $widget_name . ' Sidebar', 'nika' ),
			'id' => $widget_name . '-sidebar',
			'description' => __( 'Sidebar Widgets', 'nika' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s col-ss-12 col-xs-12 col-sm-6 col-md-6 col-lg-12">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-title"><h3 class="title">',
			'after_title' => '</h3></div>',
		) );

	}

	for ( $i = 1 ; $i < 4 ; $i++ ) {

		register_sidebar( array(
			'name' => __( 'Footer Sidebar ' . $i, 'apadana' ),
			'id' => 'footer-widgets-' . $i,
			'description' => __( 'Footer Widgets', 'apadana' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-title"><h3 class="title">',
			'after_title' => '</h3></div>',
		) );

	}

}

add_action( 'widgets_init', 'nika_widgets_init' );

/* ------------------------------------------------------------------------------------------------------------ */
/* Enqueue scripts and styles.
/* ------------------------------------------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------------------------------------------ */
/* Add Actions, Add Filters
/* ------------------------------------------------------------------------------------------------------------ */

/*------------------/
 * Custom Excerpt Length
**------------------*/

function nika_excerpt_length ( $length )
{

	$length = 12;

	return $length;

}

add_filter( 'excerpt_length', 'nika_excerpt_length', 999 );

/*------------------/
 * WP Head
**------------------*/

function nika_wp_head ()
{
}

add_action( 'wp_head', 'nika_wp_head' );

/*------------------/
 * WP Footer
**------------------*/

function nika_wp_footer ()
{
}

add_action( 'wp_footer', 'nika_wp_footer' );

/*------------------/
 * Body Classes
**------------------*/

function nika_body_class ( $classes )
{

	if ( is_user_logged_in() ) {

		$classes[] = 'body-logged-in';

	} else {

		$classes[] = 'body-logged-out';

	}

	return $classes;

}

add_filter( 'body_class', 'nika_body_class' );

/*------------------/
 * Excerpt More
**------------------*/

function nika_excerpt_more ( $more )
{

	return '...';

}

add_filter( 'excerpt_more', 'nika_excerpt_more' );

/* ------------------------------------------------------------------------------------------------------------ */
/* Template Tags
/* ------------------------------------------------------------------------------------------------------------ */

/*------------------/
 * Get Options
**------------------*/

function nika_get_options ( $option )
{

	switch ( $option ) {

		/*
		 * Default Sidebat
		 */

		case 'default_sidebar' :

			if ( is_page() ) {

				return 'page-sidebar';

			} elseif ( is_single() ) {

				return 'single-sidebar';

			} elseif ( is_category() ) {

				return 'category-sidebar';

			} else {

				return 'default_sidebar';

			}

			break;

	}

}

/*------------------/
 * Get Post Format
**------------------*/

function nika_get_post_format ()
{

	global $post;

	$post_format = get_post_format( $post->ID );

	if ( false === $post_format ) {

		$post_format = 'standard';

	}

	return $post_format;
}

/*------------------/
 * Main Class
**------------------*/

function nika_main_class ()
{

	return 'site-content content-side';

}

/*------------------/
 * Sidebar Class
**------------------*/

function nika_sidebar_class ()
{

	return 'site-sidebar right-side';

}

/*------------------/
 * Related Posts
**------------------*/

function nika_related_posts ()
{
}

/*------------------/
 * Featured Image
**------------------*/

function nika_featured_image ()
{
}

/*------------------/
 * Featured Posts
**------------------*/

function nika_featured_posts ()
{
}

/*------------------/
 * Pagination
**------------------*/

function nika_pagination ()
{
}

/*------------------/
 * Breadcrumbs
**------------------*/

function nika_breadcrumbs ()
{

	global $post;

	$showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show

	$delimiter = '<span class="fa"></span>'; // delimiter between crumbs

	$home = is_rtl() ? 'خانه' : 'Home'; // text for the 'Home' link

	$showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show

	$before = '<li class="active"><span class="current">'; // tag before the current crumb

	$after = '</span></li>'; // tag after the current crumb

	$homeLink = get_bloginfo( 'url' ) . '/home';

	if ( is_home() || is_front_page() ) {

		if ( $showOnHome == 1 ) {

			echo '<ul class="breadcrumb"><li><a href="' . $homeLink . '">' . $home . '</a></li></ul>';

		}

	} else {

		echo '<ul class="breadcrumb"><li><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . '</li> ';

		if ( is_category() ) {

			$thisCat = get_category( get_query_var( 'cat' ), false );

			if ( $thisCat->parent != 0 ) {

				echo get_category_parents( $thisCat->parent, TRUE, ' ' . $delimiter . ' ' );

			}

			echo $before . '' . single_cat_title( '', false ) . '' . $after;

		} elseif ( is_search() ) {

			echo $before . 'Search results for "' . get_search_query() . '"' . $after;

		} elseif ( is_day() ) {

			echo '<li><a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a> ' . $delimiter . '</li> ';
			echo '<li><a href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '">' . get_the_time( 'F' ) . '</a> ' . $delimiter . '</li> ';
			echo $before . get_the_time( 'd' ) . $after;

		} elseif ( is_month() ) {

			echo '<li><a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a> ' . $delimiter . '</li> ';
			echo $before . get_the_time( 'F' ) . $after;

		} elseif ( is_year() ) {

			echo $before . get_the_time( 'Y' ) . $after;

		} elseif ( is_single() && !is_attachment() ) {

			if ( get_post_type() != 'post' ) {

				$post_type = get_post_type_object( get_post_type() );

				$slug = $post_type->rewrite;

				echo '<li><a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';

				if ( $showCurrent == 1 ) {

					echo ' ' . $delimiter . '</li> ' . $before . get_the_title() . $after;

				}

			} else {

				$cat = get_the_category();
				$cat = $cat[0];

				$cats = get_category_parents( $cat, TRUE, ' ' . $delimiter . '</li> ' );

				if ( $showCurrent == 0 ) {

					$cats = preg_replace( "#^(.+)\s$delimiter\s$#", "$1", $cats );

				}

				echo $cats;

				if ( $showCurrent == 1 ) {

					echo $before . get_the_title() . $after;

				}

			}

		} elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {

			$post_type = get_post_type_object( get_post_type() );
			echo $before . $post_type->labels->singular_name . $after;

		} elseif ( is_attachment() ) {
			$parent = get_post( $post->post_parent );
			$cat = get_the_category( $parent->ID );
			$cat = $cat[0];
			echo get_category_parents( $cat, TRUE, ' ' . $delimiter . '</li> ' );
			echo '<li><a href="' . get_permalink( $parent ) . '">' . $parent->post_title . '</a>';
			if ( $showCurrent == 1 ) echo ' ' . $delimiter . '</li> ' . $before . get_the_title() . $after;

		} elseif ( is_page() && !$post->post_parent ) {
			if ( $showCurrent == 1 ) echo $before . get_the_title() . $after;

		} elseif ( is_page() && $post->post_parent ) {
			$parent_id = $post->post_parent;
			$breadcrumbs = array();
			while ( $parent_id ) {
				$page = get_page( $parent_id );
				$breadcrumbs[] = '<li><a href="' . get_permalink( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a>';
				$parent_id = $page->post_parent;
			}
			$breadcrumbs = array_reverse( $breadcrumbs );
			for ( $i = 0 ; $i < count( $breadcrumbs ) ; $i++ ) {
				echo $breadcrumbs[$i];
				if ( $i != count( $breadcrumbs ) - 1 ) echo ' ' . $delimiter . '</li> ';
			}
			if ( $showCurrent == 1 ) echo ' ' . $delimiter . '</li> ' . $before . get_the_title() . $after;

		} elseif ( is_tag() ) {
			echo $before . 'Posts tagged "' . single_tag_title( '', false ) . '"' . $after;

		} elseif ( is_author() ) {
			global $author;
			$userdata = get_userdata( $author );
			echo $before . 'Articles posted by ' . $userdata->display_name . $after;

		} elseif ( is_404() ) {
			echo $before . 'Error 404' . $after;
		}

		if ( get_query_var( 'paged' ) ) {
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
			echo __( 'Page' ) . ' ' . get_query_var( 'paged' );
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
		}

		echo '</ul>';

	}
}

/*------------------/
 * Post Navigation
**------------------*/

function nika_post_navigation ()
{
}

/*------------------/
 * Page Template Tabs
**------------------*/

function nika_page_template_tabs ()
{

	global $post;

	$post_cats = get_post_meta( $post->ID, 'erteashat_page_template_cats', true );

	$args = array(
		'order' => 'DESC',
		'post_type' => 'post',
		'post_status' => 'publish',
		'ignore_sticky_posts' => false,
		'no_found_rows' => false,
		'paged' => 1
	);

	if ( !empty( $post_cats ) ) {
		$args['category_name'] = $post_cats;
	}

	$the_query = new WP_Query( $args );

	if ( $the_query->have_posts() ) {

		echo '<div class="row">';

		// Tab Lists

		echo
		'<div class="col-md-3 col-start">',
		'<ul class="tab-list">';


		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			echo '<li class="tab-link" data-tab="tab-' . get_the_id() . '">' . get_the_title() . '</li>';

		}

		echo
		'</ul>',
		'</div>';

		// Tab Content

		echo
		'<div class="col-md-9 col-end">',
		'<div class="tabs">';

		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			echo '<div id="tab-' . get_the_id() . '" class="tab-content">';

			the_content();

			echo '</div>';

		}

		echo
		'</div>',
		'</div>';

		echo '</div>';

	} else {

		nika_errors( '404' );

	}

}

/*------------------/
 * Errors
**------------------*/

function nika_errors ( $error = null )
{

	switch ( $error ) {

		/*------------------/
		 * 404
		**------------------*/

		case '404' :

			echo __( 'متاسفانه مطلب مورد نظر شما موجود نمی باشد.', '' );
			break;

	}

}

/*------------------/
 * Post Tabs
**------------------*/

function nika_metabox_tabs ()
{
	global $post;

	$post_cats = get_post_meta( $post->ID, 'erteashat_metabox_tabs', true );

	if ( $post_cats == 'none' ) {
		return;
	}

	$args = array(
		'order' => 'DESC',
		'post_type' => 'post',
		'post_status' => 'publish',
		'ignore_sticky_posts' => false,
		'no_found_rows' => false,
		'paged' => 1
	);

	if ( !empty( $post_cats ) ) {
		$args['category_name'] = $post_cats;
	}

	$the_query = new WP_Query( $args );

    $args2 = array(
        'order' => 'ASC',
        'post_type' => 'post',
        'post_status' => 'publish',
        'ignore_sticky_posts' => false,
        'no_found_rows' => false,
        'paged' => 1,
        'category_name' => 'erteashat'
    );
	$the_query2 = new WP_Query( $args2 );


	$title1 = is_rtl() ? 'معرفی شرکت' : 'Introduction';
	$title2 = is_rtl() ? 'واحدهای شرکت' : 'Company units';

	if ( $the_query->have_posts() ) {

		echo
		'<div class="post-tabs post-content">',
		'<div class="row">';

		// Tab Lists

		echo
		'<div class="col-lg-3 col-tab-list col-start">',
        '<h5 class="v3title">'. $title1 .'</h5>',
		'<ul class="tab-list tab-list-active">';

		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			echo '<li class="tab-link" data-tab="tab-' . get_the_id() . '">' . get_the_title() . '</li>';

		}

		echo
		'</ul>';


		echo '<h5 class="v3title">'. $title2 .'</h5><ul class="tab-list">';

        while ( $the_query2->have_posts() ) {

            $the_query2->the_post();

            echo '<li class="tab-link" data-tab="tab-' . get_the_id() . '">' . get_the_title() . '</li>';

        }

        echo
        '</ul>';

		echo '</div>';

		// Tab Content

		echo
		'<div class="col-lg-9 col-tab-content col-end">',
		'<div class="tabs">';

		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			echo '<div id="tab-' . get_the_id() . '" class="tab-content">';

			the_content();

			echo '</div>';

		}
        while ( $the_query2->have_posts() ) {

            $the_query2->the_post();

            echo '<div id="tab-' . get_the_id() . '" class="tab-content">';

            the_content();

            echo '</div>';

        }

		echo
		'</div>',
		'</div>';

		echo
		'</div>',
		'</div>';

	}

	wp_reset_postdata();

}

function nika_metabox_tabs2 ()
{
    global $post;

    $post_cats = get_post_meta( $post->ID, 'erteashat_metabox_tabs', true );

    if ( $post_cats == 'none' ) {
        return;
    }

    $args = array(
        'order' => 'DESC',
        'post_type' => 'post',
        'post_status' => 'publish',
        'ignore_sticky_posts' => false,
        'no_found_rows' => false,
        'paged' => 1
    );

    if ( !empty( $post_cats ) ) {
        $args['category_name'] = $post_cats;
    }

    $the_query = new WP_Query( $args );

    if ( $the_query->have_posts() ) {

        echo
        '<div class="post-tabs post-content">',
        '<div class="row">';

        // Tab Lists

        echo
        '<div class="col-lg-3 col-tab-list col-start">',
        '<ul class="tab-list">';

        while ( $the_query->have_posts() ) {

            $the_query->the_post();

            echo '<li class="tab-link" data-tab="tab-' . get_the_id() . '">' . get_the_title() . '</li>';

        }

        echo
        '</ul>',
        '</div>';

        // Tab Content

        echo
        '<div class="col-lg-9 col-tab-content col-end">',
        '<div class="tabs">';

        while ( $the_query->have_posts() ) {

            $the_query->the_post();

            echo '<div id="tab-' . get_the_id() . '" class="tab-content">';

            the_content();

            echo '</div>';

        }

        echo
        '</div>',
        '</div>';

        echo
        '</div>',
        '</div>';

    }

    wp_reset_postdata();

}
/*------------------/
 * Post Slider
**------------------*/

function nika_metabox_slider ()
{

	global $post;

	$post_cats = get_post_meta( $post->ID, 'erteashat_metabox_slider', true );

	$post_title = get_post_meta( $post->ID, 'erteashat_metabox_slider_title', true );

	if ( $post_cats == 'none' ) {
		return;
	}

	$args = array(
		'order' => 'DESC',
		'post_type' => 'post',
		'post_status' => 'publish',
		'ignore_sticky_posts' => false,
		'no_found_rows' => false,
		'paged' => 1
	);

	if ( !empty( $post_cats ) ) {
		$args['category_name'] = $post_cats;
	}

	$the_query = new WP_Query( $args );

	if ( $the_query->have_posts() ) {

		echo '<div class="post-carousel">';

		if ( $post_title ) {

			echo '<h5 class="title">' . $post_title . '</h5>';
		}

		echo '<div class="owl-carousel carousel-items">';

		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			echo
			'<div class="item">',
				'<a href="' . esc_url( get_the_permalink() ) . '" title="' . get_the_title() . '" target="_blank">';


			if ( has_post_thumbnail() ) {

				the_post_thumbnail( 'thumb-sm' );

			} else {

				echo '<img src="' . THEME_PATH . '/assets/img/thumb-sm.jpg" alt="' . get_the_title() . '">';

			}

			echo
			'</a>',
			'</div>';
		}

		echo
		'</div>',
		'</div>';

	}

	wp_reset_postdata();

}


/*
 * v3
 * 7-11-97
 * Gallery
 */
if ( !function_exists( 'naz_post_types' ) ) {
    /*
     * Custom Post Types.
     */
    function naz_post_types ()
    {
        /*
         * Gallery
         */
        $gallery_labels = array(
            'name' => 'گالری',
        );
        $gallery_args = array(
            'public' => true,
            'labels' => $gallery_labels,
            'has_archive' => true,
            'hierarchical' => false,
            'supports' => array( 'title', 'excerpt', 'thumbnail' ),
            'exclude_from_search' => true,
            'show_ui' => true,

        );
        /*
         * Register Post Types
         */
        register_post_type( 'picture', $gallery_args );
    }
}
add_action( 'init', 'naz_post_types' );
