<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header id="header" class="site-header">
	<div class="header-wrapper">
		<div class="container">
			<div class="header-container clearfix">
				<div id="header-logo" class="header-logo logo">
					<a href="<?php echo esc_html( get_bloginfo( 'url' ) ); ?>" title="<?php echo esc_html( get_bloginfo( 'name' ) ); ?>">
						<img src="<?php echo THEME_PATH; ?>/assets/img/logo-large.png" alt="<?php echo esc_html( get_bloginfo( 'name' ) ); ?>">
					</a>
				</div>
				<nav id="header-nav" class="header-nav" role="navigation">
					<?php
					wp_nav_menu( array(
						'depth' => 3,
						'menu' => 'main',
						'theme_location' => 'main',
						'container' => '',
						'container_id' => '',
						'container_class' => '',
						'menu_class' => 'menu',
						'fallback_cb' => 'wp_bootstrap_navwalker::fallback',
						'walker' => new wp_bootstrap_navwalker()
					) );
					?>
				</nav>
				<button class="btn-sidenav" type="button">
					<span class="line"></span>
					<span class="line"></span>
					<span class="line"></span>
				</button>
			</div>
		</div>
	</div>
</header>
<div id="wrapper" class="site-wrapper">