jQuery(document).ready(function() {

	'use strict';
	
	/*
	 * Tabs
	 */

	jQuery('.tab-list:first li:first-child').addClass('active');
	
	jQuery('.tab-content:first-child').addClass('active');

	jQuery('.tab-link').click( function(){
		
		var tab_id = jQuery(this).attr('data-tab');
		
		jQuery('.tab-link').removeClass('active');
		
		jQuery('.tab-content').removeClass('active');
		
		jQuery(this).addClass('active');
		
		jQuery("#"+tab_id).addClass('active');
	
	});

	/*
	 * OWL Carousel : Carousel Data
	 */

	jQuery('.carousel-data').each(function() {
		var $owl = jQuery(this);
		$owl.owlCarousel({
			rtl : $owl.data("rtl"),
			nav : $owl.data("nav"),
			dots : $owl.data("dots"),
			loop : $owl.data("loop"),
			items : $owl.data("items"),
			center : $owl.data("center"),
			margin : $owl.data("margin"),
			slideBy : $owl.data("slideby"),
			autoplay : $owl.data("autoplay"),
			autoplayTimeout : $owl.data("autoplay-timeout"),
			navText : [ '<span class="fa fa-chevron-right"></span>','<span class="fa fa-chevron-left"></span>' ],
		});
	});
	
	jQuery('.carousel-items').owlCarousel({

		rtl : true,
		nav : true,
		dots : false,
		margin : 15,
		responsiveClass:true,
		responsive:{
			0:{
				items:1,
			},
			400:{
				items:2,
			},
			600:{
				items:3,
			},
			1200:{
				items:4,	
			}
		},
		navText : [ '<span class="fa fa-chevron-right"></span>','<span class="fa fa-chevron-left"></span>' ],
	});
	
	jQuery('.carousel-single').owlCarousel({

		rtl : true,
		nav : true,
                loop : true,
		dots : false,
                center : true,
		margin : 15,
		responsiveClass:true,
		responsive:{
			0:{
				items:1,
			},
			400:{
				items:2,
			},
			600:{
				items:3,
			},
		},
		navText : [ '<span class="fa fa-chevron-right"></span>','<span class="fa fa-chevron-left"></span>' ],
	});


	/*
	 *	Sidenav
	 */

	jQuery("#header .btn-sidenav").click(function(e) {
		
        e.preventDefault();
        
		jQuery("#sidenav-wrapper").toggleClass("toggled");
    
	});
	
	jQuery("#sidenav-wrapper .close").click(function(e) {
		
        e.preventDefault();
        
		jQuery("#sidenav-wrapper").toggleClass("toggled");
    
	});


	/*
	 * Sticky Navigation Menu
	 */
	

/*
	 * V3
	 * Multiple Form Table
	 */
	 
	var studying_count      = 2;
	var studying_panels     = jQuery('#multiple-table-studying #table-studying .tbody');
	var studying_button_add = jQuery('#multiple-table-studying .add-field');
	var studying_button_del = jQuery('#multiple-table-studying .del-field');
	
	// Studying
	
	studying_button_add.on( 'click', function(e) {
		
		e.preventDefault();
		
		studying_panels.append('<tr class="tr">' + '<td class="radif"> ' + studying_count + '</td>' + '<td><textarea name="studying-a-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-b-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-c-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-d-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-e-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-f-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-g-' + studying_count + '"></textarea></td>' + '<td><textarea name="studying-h-' + studying_count + '"></textarea></td>' + '</tr>');
		
		studying_count++;
	
	});
	
	studying_button_del.on( 'click', function(e) {
		
		e.preventDefault();
		
		jQuery(this).parents('#multiple-table-studying').find('#table-studying .tbody .tr:last-child').remove();
		
		if (studying_count > 1) { studying_count--;}
		
	
	});
	
	// Expertise
	
	var expertise_count      = 2;
	var expertise_panels     = jQuery('#multiple-table-expertise #table-expertise .tbody');
	var expertise_button_add = jQuery('#multiple-table-expertise .add-field');
	var expertise_button_del = jQuery('#multiple-table-expertise .del-field');
	
	expertise_button_add.on( 'click', function(e) {
		
		e.preventDefault();
		
		expertise_panels.append('<tr class="tr">' + '<td class="radif"> ' + expertise_count + '</td>' + '<td><textarea name="expertise-a-' + expertise_count + '"></textarea></td>' + '<td><textarea name="expertise-b-' + expertise_count + '"></textarea></td>' + '<td><textarea name="expertise-c-' + expertise_count + '"></textarea></td>' + '<td><textarea name="expertise-d-' + expertise_count + '"></textarea></td>' + '<td><textarea name="expertise-e-' + expertise_count + '"></textarea></td>' + '</tr>');
		
		expertise_count++;
	
	});
	
	expertise_button_del.on( 'click', function(e) {
		
		e.preventDefault();
		
		jQuery(this).parents('#multiple-table-expertise').find('#table-expertise .tbody .tr:last-child').remove();
		
		if (expertise_count > 1) { expertise_count--;}
		
	
	});
	
	// Skills
	
	var skill_count      = 2;
	var skill_panels     = jQuery('#multiple-table-skill #table-skill .tbody');
	var skill_button_add = jQuery('#multiple-table-skill .add-field');
	var skill_button_del = jQuery('#multiple-table-skill .del-field');
	
	skill_button_add.on( 'click', function(e) {
		
		e.preventDefault();
		
		skill_panels.append('<tr class="tr">' + '<td class="radif"> ' + skill_count + '</td>' + '<td><textarea name="skill-a-' + skill_count + '"></textarea></td>' + '<td><textarea name="skill-b-' + skill_count + '"></textarea></td>' + '</tr>');
		
		skill_count++;
	
	});
	
	skill_button_del.on( 'click', function(e) {
		
		e.preventDefault();
		
		jQuery(this).parents('#multiple-table-skill').find('#table-skill .tbody .tr:last-child').remove();
		
		if (skill_count > 1) { skill_count--;}
		
	
	});
	
	// Language
	
	var language_count      = 2;
	var language_panels     = jQuery('#multiple-table-language #table-language .tbody');
	var language_button_add = jQuery('#multiple-table-language .add-field');
	var language_button_del = jQuery('#multiple-table-language .del-field');
	
	language_button_add.on( 'click', function(e) {
		
		e.preventDefault();
		
		language_panels.append('<tr class="tr">' + '<td class="radif"> ' + language_count + '</td>' + '<td><textarea name="language-a-' + language_count + '"></textarea></td>' + '<td><select name="language-b-1"><option value=""></option><option value="1">عالی</option><option value="2">خوب</option><option value="3">متوسط</option><option value="4">ضعیف</option></select></td>' + '<td><select name="language-c-1"><option value=""></option><option value="1">عالی</option><option value="2">خوب</option><option value="3">متوسط</option><option value="4">ضعیف</option></select></td>' + '<td><select name="language-d-1"><option value=""></option><option value="1">عالی</option><option value="2">خوب</option><option value="3">متوسط</option><option value="4">ضعیف</option></select></td>' + '<td><select name="language-e-1"><option value=""></option><option value="1">عالی</option><option value="2">خوب</option><option value="3">متوسط</option><option value="4">ضعیف</option></select></td>' + '</tr>');
		
		language_count++;
	
	});
	
	language_button_del.on( 'click', function(e) {
		
		e.preventDefault();
		
		jQuery(this).parents('#multiple-table-language').find('#table-language .tbody .tr:last-child').remove();
		
		if (language_count > 1) { language_count--;}
		
	
	});
	
	// Experience
	
	var experience_count      = 2;
	var experience_panels     = jQuery('#multiple-table-experience #table-experience .tbody');
	var experience_button_add = jQuery('#multiple-table-experience .add-field');
	var experience_button_del = jQuery('#multiple-table-experience .del-field');
	
	experience_button_add.on( 'click', function(e) {
		
		e.preventDefault();
		
		experience_panels.append('<tr class="tr">' + '<td class="radif"> ' + experience_count + '</td>' + '<td><textarea name="experience-a-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-b-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-c-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-d-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-e-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-f-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-g-' + experience_count + '"></textarea></td>' + '<td><textarea name="experience-h-' + experience_count + '"></textarea></td>' + '</tr>');
		
		experience_count++;
	
	});
	
	experience_button_del.on( 'click', function(e) {
		
		e.preventDefault();
		
		jQuery(this).parents('#multiple-table-experience').find('#table-experience .tbody .tr:last-child').remove();
		
		if (experience_count > 1) { experience_count--;}
		
	
	});

    /*
     * v3
     * File Upload
     * 7-11-97
     */
    jQuery('#chooseFile').bind('change', function () {
        var filename = jQuery("#chooseFile").val();
        if (/^\s*$/.test(filename)) {
            jQuery(".file-upload").removeClass('active');
            jQuery("#noFile").text("No file chosen...");
        }
        else {
            jQuery(".file-upload").addClass('active');
            jQuery("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });

});

