<?php

/**
 * Template Name: Home Slider
 */
 
get_header(); 

?>

<div id="home-page" class="home-page">

    
	<?php

	$rtl = '';
	$rtl = is_rtl() ? 'data-rtl="true"' : 'data-rtl="false"';


	$args = array(
		'order'               => 'DESC',
		'post_type'           => 'post',
		'post_status'         => 'publish',
		'category_name'       => 'products',
		'ignore_sticky_posts' => false,
		'no_found_rows'       => false,
		'paged'               => 1
	);

	$the_query  = new WP_Query( $args );

	if ( $the_query->have_posts() ) {

		echo '<div id="home-carousel" class="owl-carousel carousel-data" data-loop="true" data-autoplayTimeout="3000" data-speed="750" data-autoplay="true" data-nav="true" data-items="1" ' . $rtl . '>';
		
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			echo '<div class="item"><div class="img"><span class="bg" style="background-image: url(' . get_the_post_thumbnail_url( null, 'thumb-xx' ) . ');"></span></div><div class="pat"></div>';
			
			echo
			'<div class="details">',
				'<div class="center">',
					'<div class="inner">',
						'<a href="' . esc_url( get_the_permalink() ) . '">',
							'<h2 class="title">', get_the_title(), '</h2>',
							'<p class="desc">', get_the_excerpt() ,'</p>',
						'</a>',
					'</div>',
				'</div>',
			'</div>';

			echo '</div>';	
		
		}
		
		echo '</div>';
		
	}
	
    ?>

</div>

<?php

get_footer(); 

?>

