<?php

/**
 * Template Name: Products
 */

get_header();

global $post;

$args = array(
	'order' => 'DESC',
	'post_type' => 'post',
	'post_status' => 'publish',
	'category_name' => 'products',
	'ignore_sticky_posts' => false,
	'no_found_rows' => false,
	'paged' => 1
);

$the_query = new WP_Query( $args );

?>
<div class="page-image-para">
	<div class="parallax-window" data-parallax="scroll"
		 data-image-src="<?php echo get_the_post_thumbnail_url() ?>"></div>
	<div class="pattern"></div>
</div>
<header class="page-header">
	<div class="container">
		<h1 class="title">
			<?php echo get_the_title(); ?>
		</h1>
		<?php nika_breadcrumbs(); ?>
	</div>
</header>
<div id="page-products" class="page-content">
	<div class="container">
		<div class="lines">
			<div class="line-1"></div>
			<div class="line-2"></div>
		</div>
		<div class="page-body">
			<div class="row">
				<div id="content" class="content-full">
					<div class="content-wrapper">
						<div class="row">
							<div class="col-lg-12">
								<div class="box-title">
									<h2 class="title">
										<?php echo is_rtl() ? 'محصولات' : 'Products'; ?>
									</h2>
									<span class="line"></span>
								</div>
							</div>
							<div class="col-sm-12">
								<?php if ( $the_query->have_posts() ) : ?>
									<div class="row">
										<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
											<div class="col-lg-12">
												<div class="card">
													<div class="row">
														<div class="col-12 col-sm-2">
															<div class="img">
																<a href="<?php echo esc_url( get_the_permalink() ); ?>"
																   title="<?php echo esc_attr( get_the_title() ); ?>">
																	<?php the_post_thumbnail( 'thumb-ch' ); ?>
																</a>
															</div>
														</div>
														<div class="col-12 col-sm-10">
															<div class="details">
																<a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>">
																	<h3 class="title">
																		<?php echo get_the_title(); ?>
																	</h3>
																</a>
																<?php the_excerpt(); ?>
															</div>
														</div>
													</div>
												</div>
											</div>
										<?php endwhile; ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<?php

get_footer();

?>
