<?php

/**
 * Template Name: First page
 */

?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Erteashat Sanat Arak</title>
	<style>
		body {
			width: 100%;
			margin: 0;
		}
		a,
		a:hover,
		a:focus {
			text-decoration: none;
		}
		.logo {
			max-width: 270px;
			height: auto;
			margin: auto;
			margin-bottom: 30px;
		}
		.img {
			width: 270px;
			height: auto;
			background: #fff;
			position: relative;
		}
		img {
			max-width: 100%;
			height: auto;
			display: block;
		}
		.first-page {
			width: 100%;
			height: 100%;
			overflow: hidden;
			position: absolute;
			background: #eee;
		}
		.center {
			top: 0;
			bottom: 0;
			width: 100%;
			height: 100%;
			display: flex;
			position: absolute;
			text-align: center;
			align-items: center;
			justify-content: center;
		}
		.col-6 {
			text-align: center;
			min-width: 270px;
			min-height: 300px;
			background: #fff;
			display: inline-block;
			padding: 15px 30px 30px;
			margin: 0 15px;
		}
		.circle-1 {
			width: 1200px;
			height: 1200px;
			background: rgba(204, 204, 204, .06);
			border-radius: 50%;
			position: absolute;
			left: -600px;
			bottom: 0;
		}
		.circle-2 {
			width: 1200px;
			height: 1200px;
			background: rgba(204, 204, 204, .06);
			border-radius: 50%;
			position: absolute;
			right: -600px;
			top: 0;
		}

		.select-lang {
			top: calc(50% - 14px);
			left: 0;
			right: 0;
			width: 180px;
			height: 28px;
			position: absolute;
			margin: auto;
		}
		a.lang {
			width: 75px;
			height: 27px;
			color: #f9f9f9;
			font-size: .9em;
			line-height: 27px;
			background: #014b88;
			display: inline-block;
			border-radius: 3px;
			margin: 0 1px;
			opacity: 0;
		}
		a.lang:hover {
			background: #01284f;
		}
		a.lang.en {
			left: 0;
		}
		a.lang.fa {
			right: 0;
		}

		.item:hover .lang {
			opacity: .9;
		}
		.item:hover .img img {
			opacity: .3;
		}

		img,
		.lang {
			transition: all 450ms;
		}

		@media (max-width: 767px) {
			.lang {
				opacity: .6 !important;
			}
			.lang:hover,
			.item:hover .lang {
				opacity: 1 !important;
			}
		}
	</style>
</head>
<div id="first-page" class="first-page">
	<div class="circle-1"></div>
	<div class="circle-2"></div>
	<div class="container">
		<div class="center">
			<div class="row">
				<div class="col-6 item">
					<div class="logo">
						<img src="<?php echo THEME_PATH; ?>/assets/img/logo-left.jpg" alt="" class="logo">
					</div>
					<div class="img">
						<img src="<?php echo THEME_PATH; ?>/assets/img/first-img-left.jpg" alt="" class="img">
						<div class="select-lang">
							<a href="http://www.mobilehospital.co/" class="lang en">
								<span class="lang-title">
									English
								</span>
							</a>
						</div>
					</div>
				</div>
				<div class="col-6 item">
					<div class="logo">
						<img src="<?php echo THEME_PATH; ?>/assets/img/logo-right.jpg" alt="">
					</div>
					<div class="img">
						<img src="<?php echo THEME_PATH; ?>/assets/img/first-img-right.jpg" alt="">
						<div class="select-lang">
							<a href="http://en.erteashat.com/home" class="lang en">
								<span class="lang-title">
									English
								</span>
							</a>
							<a href="http://erteashat.com/home" class="lang fa">
								<span class="lang-title">
									فارسی
								</span>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<body></body>
</html>
