<?php

/**
 * Template Name: Gallery
 */

$i = 0;
$post_type = 'picture';
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

$my_array = array(
    'order' => 'ASC',
    'paged' => $paged,
    'post_type' => $post_type,
    'post_status' => 'publish',
    'posts_per_page' => 15,
);
$my_query = new WP_Query( $my_array );

get_header();

if ( have_posts() ) : while ( have_posts() ) : the_post();

	?>
	<div class="page-image-para">
		<div class="parallax-window" data-parallax="scroll" data-image-src="<?php echo get_the_post_thumbnail_url() ?>"></div>
		<div class="pattern"></div>
	</div>
	<header class="page-header">
		<div class="container">
			<h1 class="title">
				<?php echo get_the_title(); ?>
			</h1>
			<?php nika_breadcrumbs(); ?>
		</div>
	</header>
	<div class="page-content">
		<div class="container">
			<div class="lines">
				<div class="line-1"></div>
				<div class="line-2"></div>
			</div>
			<div class="page-body">
				<div class="row">
					<div id="content" class="content-full">
						<div class="content-wrapper">
							<?php if ( $my_query->have_posts() ) : ?>
							<ul class="gallery-list row">
                                <?php while ( $my_query->have_posts() ) : $my_query->the_post(); $i++; ?>
								<li class="col-sm-6 col-md-6 col-lg-4">
									<div class="img" onclick="openModal();currentSlide(<?php echo intval( $i ); ?>);">
                                        <?php the_post_thumbnail( 'thumb-xs' ); ?>
                                        <div class="hover">
                                            <h2 class="title">
                                                <?php the_title(); ?>
                                            </h2>
                                        </div>
									</div>
								</li>
								<?php endwhile; ?>
							</ul>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
    <div id="modal-gallery" class="modal">
        <span class="close cursor" onclick="closeModal()">&times;</span>
        <div class="modal-body">
            <?php while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
                <div class="carousel-item">
                    <div class="center">
                        <div class="img">
                            <?php the_post_thumbnail( 'medium_large' ); ?>
                            <div class="inner">
                                <h2 class="title">
                                    <?php the_title(); ?>
                                </h2>
                                <div class="excerpt">
                                    <?php the_excerpt(); ?>
                                </div>
                            </div>
                            <span class="cover"></span>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <span class="prev" onclick="plusSlides(-1)">
			<i class="fa fa-chevron-left"></i>
		</span>
            <span class="next" onclick="plusSlides(1)">
			<i class="fa fa-chevron-right"></i>
		</span>
        </div>
    </div>
    <script>
        function openModal() {
            document.getElementById('modal-gallery').style.display = "block";
        }

        function closeModal() {
            document.getElementById('modal-gallery').style.display = "none";
        }

        var slideIndex = 1;
        showSlides(slideIndex);

        function plusSlides(n) {
            showSlides(slideIndex += n);
        }

        function currentSlide(n) {
            showSlides(slideIndex = n);
        }

        function showSlides(n) {
            var i;
            var slides = document.getElementsByClassName("carousel-item");

            if (n > slides.length) {
                slideIndex = 1
            }
            if (n < 1) {
                slideIndex = slides.length
            }
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            slides[slideIndex - 1].style.display = "block";
        }
    </script>
<?php

endwhile; endif;

get_footer();

?>
