<?php

/**
 * Template Name: Contact Us
 */

get_header();

if ( have_posts() ) : while ( have_posts() ) : the_post();

	?>
<div class="page-image-para">
	<div class="parallax-window" data-parallax="scroll" data-image-src="<?php echo get_the_post_thumbnail_url() ?>"></div>
	<div class="pattern"></div>
</div>
<header class="page-header">
	<div class="container">
		<h1 class="title">
			<?php echo get_the_title(); ?>
		</h1>
		<?php nika_breadcrumbs(); ?>
	</div>
</header>
<div id="page-contact" class="page-content page-contact">
	<div class="container">
		<div class="lines">
			<div class="line-1"></div>
			<div class="line-2"></div>
		</div>
		<div class="page-body">
			<div class="row">
				<div id="content" class="content-full">
					<div class="content-wrapper">
						<?php the_content(); ?>
						<div class="row">
							<div class="col-lg-6">
								<div class="box-title">
									<h2 class="title">
										<?php echo is_rtl() ? 'موقعیت دفتر مرکزی روی نقشه' : 'Central office location on map'; ?>
									</h2>
									<span class="line"></span>
								</div>
								<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d809.7627829281364!2d51.382289365391415!3d35.72496099396826!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzXCsDQzJzI5LjYiTiA1McKwMjInNTkuMSJF!5e0!3m2!1sen!2s!4v1497696460274" frameborder="0" style="border:0; width:100%;" allowfullscreen></iframe>
							</div>
							<div class="col-lg-6">
								<div class="box-title">
									<h2 class="title">
										<?php echo is_rtl() ? 'موقعیت کارخانه روی نقشه' : 'Factory location on map'; ?>
									</h2>
									<span class="line"></span>
								</div>
								<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3301.890149887486!2d49.96944231485438!3d34.149152420065086!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzTCsDA4JzU2LjkiTiA0OcKwNTgnMTcuOSJF!5e0!3m2!1sen!2s!4v1497697513090" frameborder="0" style="border:0; width:100%;" allowfullscreen></iframe>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-6">
								<?php echo do_shortcode( '[contact-form-7 id="116" title="Contact Form"]' ); ?>
							</div>
							<div class="col-lg-6">
								<div class="box">
									<div class="box-title">
										<h2 class="title">
											<?php echo is_rtl() ? 'کارخانه' : 'Factory'; ?>
										</h2>
										<span class="line"></span>
									</div>
									<div class="box-content">
										<p class="desc">
											<?php echo is_rtl() ? 'اراک، شهرک صنعتی خیرآباد، خیابان 301، خیابان پویندگان غربی' : 'West Pouyandegan street, 301 street , Kheir Abad industrial zone, Arak , Iran'; ?>
										</p>
										<p class="desc info">
											<span class="block">
												<?php echo is_rtl() ? 'کدپستی:' : 'PostalCode:'; ?>
												<span class="num">3837141631 </span>
											</span>
											<span class="block">
												<?php echo is_rtl() ? 'تلفن:' : 'Phone:'; ?>
												<span class="num">+98 86-33554201-7</span>
											</span>
											<span class="block">
												<?php echo is_rtl() ? 'فکس:' : 'Fax:'; ?>
												<span class="num">+98 86-33554209</span>
											</span>
										</p>
									</div>
								</div>
								<div class="box">
									<div class="box-title">
										<h2 class="title">
											<?php echo is_rtl() ? 'دفتر مرکزی' : 'Central Office'; ?>
										</h2>
										<span class="line"></span>
									</div>
									<div class="box-content">
										<p class="desc">
											<?php echo is_rtl() ? 'تهران، ضلع شمال شرقی تقاطع بزرگراه چمران و جلال آل احمد، کوی پروانه، پلاک 4، واحد 23' : 'No. 23, Building 4, Parvaneh alley, Chamran – Jalale-Al-e-Ahmad Crossroad, Tehran , Iran'; ?>
										</p>
										<p class="desc info">
											<span class="block">
												<?php echo is_rtl() ? 'کدپستی:' : 'PostalCode:'; ?>
												<span class="num">1439914143</span>
											</span>
											<span class="block">
												<?php echo is_rtl() ? 'تلفن:' : 'Phone:'; ?>
												<span class="num">+98 21- 88331041-2</span>
											</span>
											<span class="block">
												<?php echo is_rtl() ? 'فکس:' : 'Fax:'; ?>
												<span class="num">+98 21- 88339417</span>
											</span>
										</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div><?php

endwhile; endif;

get_footer();

?>